/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.EventHooks;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestInterface;

public class PlayerQuestData {
    public HashMap<Integer, QuestData> activeQuests = new HashMap();
    public HashMap<Integer, Long> finishedQuests = new HashMap();
    public boolean updateClient;

    public boolean checkQuestCompletion(EntityPlayer player, QuestData data) {
        QuestInterface inter = data.quest.questInterface;
        if (inter.isCompleted(player)) {
            if (data.isCompleted && data.quest.completion == EnumQuestCompletion.Npc) {
                return false;
            }
            if (!data.quest.complete(player, data)) {
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.MESSAGE, "quest.completed", data.quest.getTitle(), 2);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.CHAT, "quest.completed", ": ", data.quest.getTitle());
            }
            data.isCompleted = true;
            this.updateClient = true;
            EventHooks.onQuestFinished(PlayerData.get((EntityPlayer)player).scriptData, data.quest);
            return true;
        }
        return false;
    }

    public QuestData getQuestCompletion(EntityPlayer player, EntityNPCInterface npc) {
        for (QuestData data : this.activeQuests.values()) {
            Quest quest = data.quest;
            if (quest == null || quest.completer == null || quest.completion != EnumQuestCompletion.Npc || !quest.completer.func_70005_c_().equals(npc.func_70005_c_()) || !quest.questInterface.isCompleted(player)) continue;
            return data;
        }
        return null;
    }

    public void loadNBTData(NBTTagCompound mainCompound) {
        if (mainCompound == null) {
            return;
        }
        NBTTagCompound compound = mainCompound.func_74775_l("QuestData");
        HashMap<Integer, Long> finishedMap = new HashMap<Integer, Long>();
        if (compound.func_150297_b("CompletedQuests", 9) && compound.func_150295_c("CompletedQuests", 10).func_74745_c() > 0) {
            for (int i = 0; i < compound.func_150295_c("CompletedQuests", 10).func_74745_c(); ++i) {
                NBTTagCompound dataNBT = compound.func_150295_c("CompletedQuests", 10).func_150305_b(i);
                finishedMap.put(dataNBT.func_74762_e("Quest"), dataNBT.func_74763_f("Date"));
            }
        }
        this.finishedQuests = finishedMap;
        HashMap<Integer, QuestData> activeMap = new HashMap<Integer, QuestData>();
        if (compound.func_150297_b("ActiveQuests", 9) && compound.func_150295_c("ActiveQuests", 10).func_74745_c() > 0) {
            for (int i = 0; i < compound.func_150295_c("ActiveQuests", 10).func_74745_c(); ++i) {
                NBTTagCompound dataNBT = compound.func_150295_c("ActiveQuests", 10).func_150305_b(i);
                int id = dataNBT.func_74762_e("Quest");
                Quest quest = QuestController.instance.quests.get(id);
                if (quest == null) continue;
                QuestData data = new QuestData(quest);
                data.readEntityFromNBT(dataNBT);
                activeMap.put(id, data);
            }
        }
        this.activeQuests = activeMap;
    }

    public void saveNBTData(NBTTagCompound mainCompound) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList finishedList = new NBTTagList();
        for (int quest : this.finishedQuests.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Quest", quest);
            nbttagcompound.func_74772_a("Date", this.finishedQuests.get(quest).longValue());
            finishedList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("CompletedQuests", (NBTBase)finishedList);
        NBTTagList activeList = new NBTTagList();
        for (int id : this.activeQuests.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Quest", id);
            this.activeQuests.get(id).writeEntityToNBT(nbt);
            activeList.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("ActiveQuests", (NBTBase)activeList);
        mainCompound.func_74782_a("QuestData", (NBTBase)compound);
    }
}

